using System;
using System.Collections.Generic;
using System.Globalization;


class Solution
{
    static void Main()
    {
        string prva = Console.ReadLine();
        if (prva == null) return;
        string[] del = prva.Split(new[]{' ', '\t'}, StringSplitOptions.RemoveEmptyEntries);
        int n = int.Parse(del[0]);
        double eps = double.Parse(del[1], CultureInfo.InvariantCulture);
        double[] x = new double[n];
        double[] y = new double[n];
        for (int i = 0; i < n; i++)
        {
            string lin = Console.ReadLine();
            string[] p = lin.Split(new[]{' ', '\t'}, StringSplitOptions.RemoveEmptyEntries);
            x[i] = double.Parse(p[0], CultureInfo.InvariantCulture);
            y[i] = double.Parse(p[1], CultureInfo.InvariantCulture);
        }

        double s = eps / 2.0;
        if (s <= 0.0) s = eps == 0.0 ? 0.001 : eps / 2.0;
        int m = (int)Math.Ceiling(1.0 / s);
        if (m < 1) m = 1;
        int limit = (int)Math.Floor(18.0 / (eps * eps));
        if (limit < 1) limit = 1;

        Dictionary<long,int> mapa = new Dictionary<long,int>();
        List<int> izabrani = new List<int>();
        for (int i = 0; i < n; i++)
        {
            int gx = (int)Math.Floor(x[i] / s);
            int gy = (int)Math.Floor(y[i] / s);
            if (gx < 0) gx = 0;
            if (gy < 0) gy = 0;
            if (gx >= m) gx = m - 1;
            if (gy >= m) gy = m - 1;
            long key = ((long)gx << 32) | (uint)gy;
            if (!mapa.ContainsKey(key))
            {
                if (izabrani.Count < limit)
                {
                    mapa[key] = i + 1;
                    izabrani.Add(i + 1);
                }
            }
        }

        if (izabrani.Count == 0)
        {
            Console.WriteLine("1");
            Console.WriteLine("1");
            return;
        }

        Console.WriteLine(izabrani.Count);
        for (int i = 0; i < izabrani.Count; i++)
        {
            if (i > 0) Console.Write(" ");
            Console.Write(izabrani[i]);
        }
        Console.WriteLine();

        for (int i = 0; i + 1 < izabrani.Count; i++)
        {
            Console.WriteLine(izabrani[i] + " " + izabrani[i + 1]);
        }
    }
}